


 /**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       The main Code's c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/11/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_MEM_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_USBD_API.h"
#include "MG32_USBD_EasyCOM_API.h"
#include "MG32_USBD_EasyHID_API.h"
 
/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static void API_USBD_Event(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/  
extern void MCU_Init(void);
 
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	    Main function in the project.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
int main(void)
{
    //==========================================
    //IC hardware initial (ChipInit_Wizard)
    UnProtectModuleReg(MEMprotect);
    MEM->CR0.MBIT.FWAIT  = 1;
    MEM->CR0.MBIT.HSP_EN = 1;
    ProtectModuleReg(MEMprotect);
    
    MCU_Init();
    
    //==========================================================
    //1. URT : 
    //    (1). TX PIN = PB8
    //    (2). RX PIN = PB9
    //    (3). Baud-Rate = 256000 ~ 1200
    //===========================================================
    while(1)
    {
        API_USBD_Event();
        API_USBD_COM_main();
        
    }
}
/**
 *******************************************************************************
 * @brief	    Main function in the project.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */ 
static void API_USBD_Event(void)
{
    uint32_t API_USBD_Event;
    
    
    API_USBD_Event = Ep0.USBStatus & USB_STATUS_BUS_MASK;
    
    if( API_USBD_Event != 0)
    {
        switch( API_USBD_Event)
        {
            //============================================================================================
            // During handling the ohter functions USB bus happen suspend status. 
            case USB_STATUS_BUS_SUSPEND:
                                                                          Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_SUSPEND));
                                                                          // To do......
                                                                          
                                                                          USB_IT_Config( USB_IT_BUS_RWKF , ENABLE);               /*!< Enable USB Bus event wakeup interrupt in STOP mode.*/ 

                                                                          STOP_WFI();                                             /*!< IC into STOP mode*/
                                                                          
                                                                          break;
            //============================================================================================
            //Detect USB Bus no supsend in STOP mode. 
            case USB_STATUS_BUS_BUSEVENT_WAKEUP:
                                                                          Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_BUSEVENT_WAKEUP));
                                                                          
                                                                          // To do......
                                                                          break;
            //============================================================================================
            //During handling the other functions extern wakeup signal happen.
            case USB_STATUS_BUS_EXTIEVENT_WAKEUP:
                                                                          Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_EXTIEVENT_WAKEUP));
                                                                          //To do......
                                                                          break;
            //============================================================================================
            //During handling the ohter function USB bus happen resume status.
            case (USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESUME):
            case (USB_STATUS_BUS_RESUME):
                                                                          Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~(USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESUME)));
                                                                          // To do......
                                                                          break;
            //============================================================================================
            case (USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESET):
            case USB_STATUS_BUS_RESET:
                                                                          Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~(USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESET)));
                                                                          // To do...
                                                                          
                                                                          break;
            default:
                                                                          // To do......
                                                                          break;
        }
    
    }
    if( (Ep0.USBStatus & USB_STATUS_ENUMERATION_MASK) == USB_STATUS_ENUMERATION_OK)
    {
        // To do......
    }
}



